/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.keksuccino.fancymenu.menu.button.ButtonScriptEngine;
import de.keksuccino.fancymenu.menu.fancy.DynamicValueHelper;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.resources.TextureHandler;
import de.keksuccino.konkrete.sound.SoundHandler;
import java.io.File;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;

public class ButtonCustomizationItem
extends CustomizationItemBase {
    public AdvancedButton button;
    private String hoverLabel;
    private String hoverSound;
    private boolean hover = false;
    private boolean onlyMultiplayer = false;
    private boolean onlySingleplayer = false;
    private boolean onlyOutgame = false;

    public ButtonCustomizationItem(PropertiesSection item) {
        super(item);
        if (this.action != null && this.action.equalsIgnoreCase("addbutton")) {
            String desc;
            String onlyX;
            this.value = item.getEntryValue("label");
            if (this.value == null) {
                this.value = "";
            }
            if (!ButtonCustomizationItem.isEditorActive()) {
                this.value = DynamicValueHelper.convertFromRaw(this.value);
            }
            String buttonaction = item.getEntryValue("buttonaction");
            String actionvalue = item.getEntryValue("value");
            String backNormal = item.getEntryValue("backgroundnormal");
            String backHover = item.getEntryValue("backgroundhovered");
            if (buttonaction == null) {
                return;
            }
            if (actionvalue == null) {
                actionvalue = "";
            }
            if (!ButtonCustomizationItem.isEditorActive()) {
                actionvalue = DynamicValueHelper.convertFromRaw(actionvalue);
            }
            this.hoverSound = item.getEntryValue("hoversound");
            if (this.hoverSound != null) {
                this.hoverSound = this.hoverSound.replace("\\", "/");
                File f = new File(this.hoverSound);
                if (f.exists() && f.isFile() && f.getName().endsWith(".wav")) {
                    MenuCustomization.registerSound(this.hoverSound, this.hoverSound);
                } else {
                    this.hoverSound = null;
                }
            }
            this.hoverLabel = item.getEntryValue("hoverlabel");
            if (this.hoverLabel != null && !ButtonCustomizationItem.isEditorActive()) {
                this.hoverLabel = DynamicValueHelper.convertFromRaw(this.hoverLabel);
            }
            if ((onlyX = item.getEntryValue("onlydisplayin")) != null) {
                if (onlyX.equalsIgnoreCase("outgame")) {
                    this.onlyOutgame = true;
                }
                if (onlyX.equalsIgnoreCase("multiplayer")) {
                    this.onlyMultiplayer = true;
                }
                if (onlyX.equalsIgnoreCase("singleplayer")) {
                    this.onlySingleplayer = true;
                }
            }
            String finalAction = actionvalue;
            this.button = new AdvancedButton(0, 0, this.width, this.height, this.value, true, press -> ButtonScriptEngine.runButtonAction(buttonaction, finalAction));
            String click = item.getEntryValue("clicksound");
            if (click != null) {
                click.replace("\\", "/");
                File f = new File(click);
                if (f.exists() && f.isFile() && f.getPath().toLowerCase().endsWith(".wav")) {
                    SoundHandler.registerSound((String)f.getPath(), (String)f.getPath());
                    this.button.setClickSound(f.getPath());
                }
            }
            if ((desc = item.getEntryValue("description")) != null) {
                this.button.setDescription(StringUtils.splitLines((String)DynamicValueHelper.convertFromRaw(desc), (String)"%n%"));
            }
            if (this.button != null && backNormal != null && backHover != null) {
                File f = new File(backNormal.replace("\\", "/"));
                File f2 = new File(backHover.replace("\\", "/"));
                if (f.isFile() && f.exists() && f2.isFile() && f2.exists()) {
                    this.button.setBackgroundTexture(TextureHandler.getResource((String)backNormal.replace("\\", "/")), TextureHandler.getResource((String)backHover.replace("\\", "/")));
                }
            }
        }
    }

    @Override
    public void render(MatrixStack matrix, Screen menu) throws IOException {
        if (!this.shouldRender()) {
            return;
        }
        if (this.onlyOutgame && Minecraft.func_71410_x().field_71441_e != null) {
            return;
        }
        if (this.onlyMultiplayer && (Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().func_71356_B())) {
            return;
        }
        if (this.onlySingleplayer && (Minecraft.func_71410_x().field_71441_e == null || !Minecraft.func_71410_x().func_71356_B())) {
            return;
        }
        this.button.func_230986_a_(this.opacity);
        int x = this.getPosX(menu);
        int y = this.getPosY(menu);
        this.button.setX(x);
        this.button.setY(y);
        if (this.button.func_230449_g_()) {
            if (this.hoverLabel != null) {
                this.button.setMessage(this.hoverLabel);
            }
            if (this.hoverSound != null && !this.hover) {
                this.hover = true;
                SoundHandler.resetSound((String)this.hoverSound);
                SoundHandler.playSound((String)this.hoverSound);
            }
        } else {
            this.button.setMessage(this.value);
            this.hover = false;
        }
        this.button.func_230430_a_(matrix, MouseInput.getMouseX(), MouseInput.getMouseY(), Minecraft.func_71410_x().func_184121_ak());
    }

    @Override
    public boolean shouldRender() {
        if (this.button == null) {
            return false;
        }
        return super.shouldRender();
    }

    public AdvancedButton getButton() {
        return this.button;
    }

    public Long getId() {
        int ori = 0;
        if (this.orientation.equalsIgnoreCase("original")) {
            ori = 1;
        } else if (this.orientation.equalsIgnoreCase("top-left")) {
            ori = 2;
        } else if (this.orientation.equalsIgnoreCase("mid-left")) {
            ori = 3;
        } else if (this.orientation.equalsIgnoreCase("bottom-left")) {
            ori = 4;
        } else if (this.orientation.equalsIgnoreCase("top-centered")) {
            ori = 5;
        } else if (this.orientation.equalsIgnoreCase("mid-centered")) {
            ori = 6;
        } else if (this.orientation.equalsIgnoreCase("bottom-centered")) {
            ori = 7;
        } else if (this.orientation.equalsIgnoreCase("top-right")) {
            ori = 8;
        } else if (this.orientation.equalsIgnoreCase("mid-right")) {
            ori = 9;
        } else if (this.orientation.equalsIgnoreCase("bottom-right")) {
            ori = 10;
        }
        String idRaw = "00" + ori + "" + Math.abs(this.posX) + "" + Math.abs(this.posY) + "" + Math.abs(this.width);
        long id = 0L;
        if (MathUtils.isLong((String)idRaw)) {
            id = Long.parseLong(idRaw);
        }
        return id;
    }
}

